/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  flash.h
//  Functions to write and read the flash memory (eeprom replacement)
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



// Set the storage address on the flash information memory
// - MSP430F2252: 4 segments (A,B,C,D) in information memory
// - 64 bytes in each segment available
// - Segment A contains calibration data and should not be used!
//   C: 0x1040, D: 0x1000
#define flash_address	0x1040



// Write unsigned integer to flash.
// Length is the number of integers to be written.
void flash_write(unsigned int *data, unsigned int length)
{
	unsigned int* flash_ptr;		// Flash pointer
	unsigned int i;
	
	flash_ptr = (unsigned int *) flash_address;	// initialize Flash pointer
	
	while(FCTL3 & BUSY);			// check busy bit
	
	// set timing generator to 400 kHz and use main clock
	FCTL2 = FWKEY + FSSEL0 + FN5 + FN3; 
	
	FCTL1 = FWKEY + ERASE;			// set erase bit
	FCTL3 = FWKEY;					// clear lock bit
	
	*flash_ptr = 0;					// dummy write to erase segment
	
	FCTL1 = FWKEY + WRT;			// enable write mode
	
	for (i=0; i<length; i++)
	{		
		*flash_ptr++ = data[i];		// write value to flash
		while(!(FCTL3 & WAIT));		// check if writing is finished
	}
	
	FCTL1 = FWKEY;					// disable write mode
	FCTL3 = FWKEY + LOCK;			// set lock bit
}



// Read unsigned integer from flash.
// Length is the number of integers to be read.
void flash_read(unsigned int *data, unsigned int length)
{
	unsigned int* flash_ptr;					// Flash pointer
	unsigned int i;
	
	flash_ptr = (unsigned int *) flash_address;	// initialize Flash pointer
	
	for (i=0; i<length; i++)
	{
		data[i] = *flash_ptr++;
	}
}



// Read the stored values from flash and check if they are in range.
void flash_restore_configuration(void)
{
	// These 15 values are stored in flash and restored after power up.
	// 1. value:	backlight setup
	// 2. value:	charge enabled
	// 3. value:	battery type
	// 4. value:	master / slave
	// 5. value:	trickle voltage
	// 6. value:	float voltage
	// 7. value:	minimum voltage
	// 8. value:	current limit
	// 9. value:	power limit
	// 10. value:	minimum current trickle
	// 11. value:	mains UVLO
	// 12. value:	mains OVV
	// 13. value:	temperature coefficient
	// 14. value:	overtemperature protection
		unsigned int flash_storage[15] = { 0, 0 };
	
	// read data from flash
  	flash_read((unsigned int*)&flash_storage, 15);
  	
  	// check if values are in range
  	if( flash_storage[0] < 3 )		backlight = flash_storage[0];
  	else backlight = 0;

  	if( flash_storage[1] < 2 )		charge_enabled = flash_storage[1];
  	else charge_enabled = 0;	// select 0 as default

  	if( flash_storage[2] < 2 ) 		battery_type = flash_storage[2];
  	else battery_type = 0;		// select 0 as default

  	if(( flash_storage[3] < 20 )&&( flash_storage[3] > 0 ))		master_slave = flash_storage[3];
  	else master_slave = 10;		// select 0 as default

  	if(( flash_storage[4] > 0 ) && ( flash_storage[4] < 275 )) 	trickle_voltage = flash_storage[4];
  	else trickle_voltage = 266;	// select 266 as default (26.6V)
  	
  	if(( flash_storage[5] > 278 ) && ( flash_storage[5] < 298 )) 	float_voltage = flash_storage[5];
  	else float_voltage = 288;	// select 288 as default (28.8V)

  	if(( flash_storage[6] > 232 ) && ( flash_storage[6] < 248 )) 	minimum_voltage = flash_storage[6];
  	else minimum_voltage = 240;	// select 240 as default (24.0V)

  	if(( flash_storage[7] > 9 ) && ( flash_storage[7] < 61 )) 	current_limit = flash_storage[7];
  	else current_limit = 5;	// select 60 as default (60A)

  	if(( flash_storage[8] > 99 ) && ( flash_storage[8] < 151 )) 	power_limit = flash_storage[8];
  	else power_limit = 144;		// select 144 as default (1440W)

  	if(( flash_storage[9] > 1 ) && ( flash_storage[9] < 11 )) 	minimum_current_trickle = flash_storage[9];
  	else minimum_current_trickle = 6;	// select 6 as default (6A)

  	if(( flash_storage[10] > 169 ) && ( flash_storage[10] < 201 )) 	mains_uvlo = flash_storage[10];
  	else mains_uvlo = 185;		// select 185 as default (185V)

  	if(( flash_storage[11] > 239 ) && ( flash_storage[11] < 281 )) 	mains_ovv = flash_storage[11];
  	else mains_ovv = 265;		// select 265 as default (265V)

  	if(flash_storage[12] < 11 ) 									temperature_coefficient = flash_storage[12];
  	else temperature_coefficient = 5;	// select 5 as default (0.5%)

  	if(( flash_storage[13] > 44 ) && ( flash_storage[13] < 81 )) 	overtemperature_protection = flash_storage[13];
  	else overtemperature_protection = 65;		// select 65 as default (65C)

 }



// Save the values of the output voltage and switching frequency to flash.
void flash_save_configuration(void)
{
	// These 15 values are stored in flash and restored after power up.
	// 1. value:	backlight setup
	// 2. value:	charge enabled
	// 3. value:	battery type
	// 4. value:	master / slave
	// 5. value:	trickle voltage
	// 6. value:	float voltage
	// 7. value:	minimum voltage
	// 8. value:	current limit
	// 9. value:	power limit
	// 10. value:	minimum current trickle
	// 11. value:	mains UVLO
	// 12. value:	mains OVV
	// 13. value:	temperature coefficient
	// 14. value:	overtemperature protection
	unsigned int flash_storage[14] = { 0, 0 };
	
	// save reference voltage and switching frequency
	flash_storage[0] = backlight;
	flash_storage[1] = charge_enabled;
	flash_storage[2] = battery_type;
	flash_storage[3] = master_slave;
	flash_storage[4] = trickle_voltage;
	flash_storage[5] = float_voltage;
	flash_storage[6] = minimum_voltage;
	flash_storage[7] = current_limit;
	flash_storage[8] = power_limit;
	flash_storage[9] = minimum_current_trickle;
	flash_storage[10] = mains_uvlo;
	flash_storage[11] = mains_ovv;
	flash_storage[12] = temperature_coefficient;
	flash_storage[13] = overtemperature_protection;
	flash_write((unsigned int*)&flash_storage, 14);
}
